/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.ftb.data.Settings;
import net.ftb.log.Logger;

public final class Parallel {
    private Parallel() {
        throw new RuntimeException("Use Parallel static methods");
    }

    public static <A, V> Collection<V> ForEach(Iterable<A> elements, F<A, V> task) {
        try {
            TaskHandler loop = new ForEach<A, V>(elements).apply(task);
            Collection values = loop.values();
            loop.executorService.shutdown();
            return values;
        }
        catch (Exception e) {
            throw new RuntimeException("ForEach method exception. " + e.getMessage());
        }
    }

    public static void For(final long from, final long to, Action<Long> action) {
        Parallel.ForEach(new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return new Iterator<Long>(){
                    private long current;
                    {
                        this.current = from;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current < to;
                    }

                    @Override
                    public Long next() {
                        return this.current++;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, action);
    }

    public static class ForEach<E, V>
    implements F<F<E, V>, TaskHandler<V>> {
        private Iterable<E> elements;
        private boolean poolSizeCheck = false;
        private int sleep = 0;
        private int maxTasksInPool = 0;
        private ExecutorService executor = Executors.newFixedThreadPool(4);

        public ForEach(Iterable<E> elements) {
            this.elements = elements;
        }

        public ForEach<E, V> configurePoolSize(int tasks, int sleepTime) {
            this.poolSizeCheck = true;
            this.sleep = sleepTime;
            this.maxTasksInPool = tasks;
            return this;
        }

        public ForEach<E, V> withFixedThreads(int threads) {
            this.executor = Executors.newFixedThreadPool(threads);
            return this;
        }

        public ForEach<E, V> customExecutor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Callable<TaskHandler<V>> prepare(final F<E, V> f) {
            return new Callable<TaskHandler<V>>(){

                @Override
                public TaskHandler<V> call() throws Exception {
                    return new ForEach(ForEach.this.elements).apply(f);
                }
            };
        }

        @Override
        public TaskHandler<V> apply(F<E, V> f) {
            return new TaskHandler<V>(this.executor, this.map(this.elements, f), this.poolSizeCheck, this.maxTasksInPool, this.sleep);
        }

        private Iterable<Callable<V>> map(final Iterable<E> elements, final F<E, V> f) {
            return new Iterable<Callable<V>>(){

                @Override
                public Iterator<Callable<V>> iterator() {
                    return new Iterator<Callable<V>>(){
                        Iterator<E> it;
                        {
                            this.it = elements.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.it.hasNext();
                        }

                        @Override
                        public Callable<V> next() {
                            final Object e = this.it.next();
                            return new Callable<V>(){

                                @Override
                                public V call() throws Exception {
                                    return f.apply(e);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
    }

    public static class TaskHandler<V> {
        private Collection<Future<V>> runningTasks = new LinkedList<Future<V>>();
        private ExecutorService executorService;

        public TaskHandler(ExecutorService executor, Iterable<Callable<V>> tasks, boolean poolSizeCheck, int maxPool, int sleep) {
            this.executorService = executor;
            for (Callable<V> task : tasks) {
                while (poolSizeCheck && ((ThreadPoolExecutor)executor).getTaskCount() - ((ThreadPoolExecutor)executor).getCompletedTaskCount() > (long)maxPool) {
                    if (Settings.getSettings().getDebugLauncher()) {
                        Logger.logDebug("system time: " + System.currentTimeMillis());
                        Logger.logDebug("task count: " + (((ThreadPoolExecutor)executor).getTaskCount() - ((ThreadPoolExecutor)executor).getCompletedTaskCount()));
                    }
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (Exception e) {}
                }
                this.runningTasks.add(executor.submit(task));
            }
        }

        public TaskHandler(ExecutorService executor, Iterable<Callable<V>> tasks) {
            this.executorService = executor;
            for (Callable<V> task : tasks) {
                this.runningTasks.add(executor.submit(task));
            }
        }

        public Collection<Future<V>> tasks() {
            return this.runningTasks;
        }

        public boolean wait(long timeout, TimeUnit unit) throws InterruptedException {
            return this.executorService.awaitTermination(timeout, unit);
        }

        public Collection<V> values() throws InterruptedException, ExecutionException {
            LinkedList<V> results = new LinkedList<V>();
            for (Future<V> future : this.runningTasks) {
                V result = future.get();
                if (result == null) continue;
                results.add(future.get());
            }
            return results;
        }

        public void shutdown() {
            this.executorService.shutdown();
        }
    }

    public static abstract class Action<E>
    implements F<E, Void> {
        @Override
        public final Void apply(E element) {
            this.doAction(element);
            return null;
        }

        public abstract void doAction(E var1);
    }

    public static interface F<E, V> {
        public V apply(E var1);
    }
}

